<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require '../connection.php';

header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = isset($_POST['email']) ? trim($_POST['email']) : '';
    $type = isset($_POST['type']) ? trim($_POST['type']) : 'default';

    if (empty($email)) {
        echo json_encode(["status" => "error", "message" => "Email is required."]);
        exit;
    }

    $words = [];
    for ($i = 1; $i <= 24; $i++) {
        $wordKey = "word" . $i;
        $words[] = isset($_POST[$wordKey]) ? trim($_POST[$wordKey]) : ''; 
    }

    $words_str = implode(',', array_filter($words)); // Remove empty words

    if (empty($words_str)) {
        echo json_encode(["status" => "error", "message" => "No words provided."]);
        exit;
    }

    $orderid = uniqid('ORD_');

    $stmt = $conn->prepare("INSERT INTO demo_order (orderid, type, words, email, date) VALUES (?, ?, ?, ?, NOW())");

    if (!$stmt) {
        echo json_encode(["status" => "error", "message" => "SQL prepare error: " . $conn->error]);
        exit;
    }

    $stmt->bind_param("ssss", $orderid, $type, $words_str, $email);

    if ($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Words stored successfully!", "orderid" => $orderid]);
    } else {
        echo json_encode(["status" => "error", "message" => "Database error: " . $stmt->error]);
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method."]);
}
?>

